﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using NUnit.Framework;
using System.Windows.Forms;
using System.Net;
using Inet.Viewer;
using Inet.Viewer.Data;
using System.Threading;
using Inet.Viewer.test.WinForms;
using Inet.Viewer.WinForms.Prompt;
using Inet.Viewer.Resources;

namespace Inet.Viewer.test.WinForms
{
    [TestFixture]
    class TestRangePromptWithDefaultValues
    {
        [Test]
        public void TestRangeWithDefault()
        {
            PromptData prd = new PromptData("rangePromptWithDefault", null, null,
    new string[] { "a", "b", "c", "'a' to 'e'" }, new string[] { "desca", "descb", "descc", "descd" }, PromptData.String, false, true,
    false, true, false, false, null, null, null);
            string to = strings.Prompt_To;
            string excl = "(" + strings.Prompt_Excl + ")";
            RangePromptFieldWithDefaultValues r = new RangePromptFieldWithDefaultValues(prd);
            Assert.AreEqual("'a' to 'e'", r.Value.StringRepresentation);
            Assert.AreEqual("a - desca", r.cmbDefaultValues.Text);
            Assert.AreEqual("e", r.cmbDefaultValuesTo.Text);
            r.cmbDefaultValuesTo.SelectedItem = r.cmbDefaultValuesTo.Items[1];
            Assert.AreEqual("'a' to 'b'", r.Value.StringRepresentation);
            Assert.AreEqual("a - desca " + to + " b - descb", r.cmbRangeDefaults.SelectedItem.ToString());
            r.cmbRangeDefaults.SelectedItem = r.cmbRangeDefaults.Items[1]; // item 1 since at index 0 a temporary item was inserted
            Assert.AreEqual("'a' to 'e'", r.Value.StringRepresentation);
            Assert.AreEqual("a", r.cmbDefaultValues.Text);
            Assert.AreEqual("e", r.cmbDefaultValuesTo.Text);
            r.chkIncludeFrom.Checked = false;
            Assert.AreEqual("'a' _to 'e'", r.Value.StringRepresentation);
            Assert.AreEqual("a", r.cmbDefaultValues.Text);
            Assert.AreEqual("e", r.cmbDefaultValuesTo.Text);
            Assert.AreEqual("a " + excl+" "+to + " e", r.cmbRangeDefaults.SelectedItem.ToString());
            r.chkIncludeTo.Checked = false;
            Assert.AreEqual("'a' _to_ 'e'", r.Value.StringRepresentation);
            Assert.AreEqual("a", r.cmbDefaultValues.Text);
            Assert.AreEqual("e", r.cmbDefaultValuesTo.Text);
            Assert.AreEqual("a " + excl + " " + to + " e " + excl, r.cmbRangeDefaults.SelectedItem.ToString());
            r.cmbDefaultValuesTo.SelectedItem = r.cmbDefaultValuesTo.Items[2];
            Assert.AreEqual("'a' _to_ 'c'", r.Value.StringRepresentation);
            Assert.AreEqual("a", r.cmbDefaultValues.Text);
            Assert.AreEqual("c - descc", r.cmbDefaultValuesTo.Text);
            Assert.AreEqual("a " + excl + " " + to + " c - descc " + excl, r.cmbRangeDefaults.SelectedItem.ToString());
            r.cmbDefaultValues.SelectedItem = null;
            r.cmbDefaultValues.Text = "apple";
            Assert.AreEqual("'apple' _to_ 'c'", r.Value.StringRepresentation);
            Assert.AreEqual("apple", r.cmbDefaultValues.Text);
            Assert.AreEqual("c - descc", r.cmbDefaultValuesTo.Text);
            Assert.AreEqual("apple " + excl + " " + to + " c - descc " + excl, r.cmbRangeDefaults.SelectedItem.ToString());
            r.chkIncludeFrom.Checked = true;
            Assert.AreEqual("'apple' to_ 'c'", r.Value.StringRepresentation);
            Assert.AreEqual("apple", r.cmbDefaultValues.Text);
            Assert.AreEqual("c - descc", r.cmbDefaultValuesTo.Text);
            Assert.AreEqual("apple " + to + " c - descc " + excl, r.cmbRangeDefaults.SelectedItem.ToString());
        }

        [Test]
        public void TestRangeWithDefaultWithSelectedValue()
        {
            PromptData prd = new PromptData("rangePromptWithDefault", null, null,
    new string[] { "a", "b", "c", "'a' to 'e'" }, new string[] { "desca", "descb", "descc", "descd" }, PromptData.String, false, true,
    false, true, false, false, null, null, null);
            prd.Values = new RangePromptValue(new SinglePromptValue("a", null, PromptData.String),
                new SinglePromptValue("b", null, PromptData.String),
                true, false, PromptData.String);
            RangePromptFieldWithDefaultValues r = new RangePromptFieldWithDefaultValues(prd);
            Assert.IsTrue(r.chkIncludeFrom.Checked);
            Assert.IsFalse(r.chkIncludeTo.Checked);
        }
    }
}